/* Reconstructed Commander Keen 1-3 Source Code
 * Copyright (C) 2021-2025 K1n9_Duk3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "KEENDEF.H"

/*
=============================================================================

			       GLOBALS

=============================================================================
*/

Sint16 eraselist[600], *eraselistptr;
Sint16 drawoffs1[BIGPORTSIZE], drawoffs0[BIGPORTSIZE];

Uint16 far *mapplane[4];		// points into map
Sint16 mapbwide,mapwwide,mapbytesextra,mapheight;

drawtype spritearray[500], *spritefreeptr;
drawtype picarray[10], *picfreeptr;
drawtype tilearray[100], *tilefreeptr;
Uint16 spritecount, piccount, tilecount;

Uint16 tics;
Uint32 lasttimecount;

void (*refreshhook)(void);

Sint16 originxtile, originytile;
Sint32 originxglobal, originyglobal;
Sint32 objectxmax, objectymax, originxmin, originymin;
Sint32 keenxmax, keenymax, originxmax, originymax;
Uint16 drawpage;
Sint16 tileAnimDelay;

boolean SNDstarted,KBDstarted;	// whether int handlers were started
boolean quitToTitle;
#if VERSION >= VER_100
boolean joyDetected;
boolean godmode;
#endif

Uint8 far *bigbuffer;
#if VERSION <= VER_100
void far *compbuf;
#endif

#if VERSION <= VER_120
Sint16 tedlevelnum;
#endif

Sint16 nextLevel;
Sint32 lastExtraScore;
Sint16 keenxspeed;
exittype playstate;

Sint16 objectcount;
objtype objlist[MAXOBJECTS];

// unused dummy variables:
Uint8 _unk_main_1[6];
Uint8 _unk_main_2[2];
Uint8 _unk_main_3[6];
Uint8 _unk_main_4[2];

/*
=============================================================================
*/

/*
=====================
=
= RF_Clear
=
=====================
*/

void RF_Clear(void)
{
	spritecount = piccount = tilecount = 0;
	spritefreeptr = spritearray;
	picfreeptr = picarray;
	tilefreeptr = tilearray;
	eraselistptr = eraselist;

	do
	{
		tics = timecount-lasttimecount;
	} while (tics < MINTICS);

	if (tics > MAXTICS)
	{
		tics = MAXTICS;
	}

	lasttimecount = timecount;
}


/*
=====================
=
= RF_Refresh
=
=====================
*/

void RF_Refresh(void)
{
	register Sint16 *ptr;
	void VidRefresh(void);

	VidRefresh();
	ptr = eraselist;
	if (drawpage)
	{
		while (ptr < eraselistptr)
		{
			drawoffs1[*ptr] = -1;
			ptr++;
		}
	}
	else
	{
		while (ptr < eraselistptr)
		{
			drawoffs0[*ptr] = -1;
			ptr++;
		}
	}
}


/*
=====================
=
= RF_PlaceSprite
=
=====================
*/

boolean RF_PlaceSprite(Sint32 x, Sint32 y, Sint16 shapenum)
{
	Sint16 tx, ty;
	Sint16 tx_min, tx_max, ty_min, ty_max, px, py, num, tilenum, tiletype;

	px = (x/PIXGLOBAL) - ((originxglobal/PIXGLOBAL) & ~15);
	py = (y/PIXGLOBAL) - ((originyglobal/PIXGLOBAL) & ~15);

	if (px < -32 || py < -32 || px > 336 || py > 199)	// minor BUG: py check should be 'py >= 208'
	{
		return false;
	}

	num = shapenum * 4 + (px & 7)/2;
	image = spritetable[num];

	px = (px+32)/8 - 4;
	tx_min = px/2;
	if (tx_min < 0)
	{
		tx_min = 0;
	}
	else if (tx_min > PORTTILESWIDE)
	{
		return false;
	}

	tx_max = (px + image.width - 1) / 2;
	if (tx_max > PORTTILESWIDE)
	{
		tx_max = PORTTILESWIDE;
	}
	else if (tx_max < 0)
	{
		return false;
	}

	ty_min = py/16;
	if (ty_min < 0)
	{
		ty_min = 0;
	}
	else if (ty_min > PORTTILESHIGH)
	{
		return false;
	}

	ty_max = (py + image.height - 1) / 16;
	if (ty_max > PORTTILESHIGH-1)
	{
		ty_max = PORTTILESHIGH-1;
	}
	else if (ty_max < 0)
	{
		return false;
	}

	px += 4;
	py += 32;

	// WARNING: There are no safety measures to prevent the code from adding a
	// new sprite entry when the spritearray is already full! This will lead to
	// memory corruption (the data following after spritearray will be
	// overwritten with a new drawtype entry). The same applies to the tilearray
	// and eraselist arrays, accessed via tilefreeptr and eraselistptr here.

	for (ty = ty_min; ty <= ty_max; ty++)
	{
		for (tx = tx_min; tx <= tx_max; tx++)
		{
			tilenum = GETTILE(tx+originxtile,ty+originytile,0);
			tiletype = tile_behavior[tilenum];
			if (tiletype >= 0)
			{
				// add tile spot to erase list to remove the
				// sprite during the next refresh:
				*eraselistptr = ty*PORTTILESWIDE + tx;
				eraselistptr++;
			}
			else	// sprite covers a foreground tile
			{
				// add the foreground tile:
				tilefreeptr->x = tx*2 + 4;
				tilefreeptr->y = ty*16 + 32;
				tilefreeptr->num = tilenum;

				// check if foreground tile has transparent parts:
				if (tiletype == -2)
				{
					// draw tile as masked tile:
					tilefreeptr->num |= 0x8000;

					// this spot also needs to be erased:
					*eraselistptr = ty*PORTTILESWIDE + tx;
					eraselistptr++;
				}
				// non-transparent foreground tiles don't need to be
				// added to the erase list (no sprite image visible)

				tilecount++;
				tilefreeptr++;
			}
		}
	}

	spritefreeptr->x = px;
	spritefreeptr->y = py;
	spritefreeptr->num = num;
	spritecount++;
	spritefreeptr++;

	return true;
}


/*
=====================
=
= RF_PlaceTile
=
=====================
*/

boolean RF_PlaceTile(Sint32 x, Sint32 y, Sint16 tilenum)
{
	Sint16 tx, ty;
	Sint16 tx_min, tx_max, ty_min, ty_max, px, py;

	px = (x/PIXGLOBAL) - ((originxglobal/PIXGLOBAL) & ~15);
	py = (y/PIXGLOBAL) - ((originyglobal/PIXGLOBAL) & ~15);

	if (px < -32 || py < -32)
	{
		return false;
	}

	px = (px+32)/8 - 4;
	tx_min = px/2;
	if (tx_min < 0)
	{
		tx_min = 0;
	}
	else if (tx_min > PORTTILESWIDE)
	{
		return false;
	}

	tx_max = (px + image.width - 1)/2;	//BUG: shouldn't use sprite width for tiles!
	if (tx_max > PORTTILESWIDE-1)
	{
		tx_max = PORTTILESWIDE-1;
	}
	else if (tx_max < 0)
	{
		return false;
	}

	ty_min = py/16;
	if (ty_min < 0)
	{
		ty_min = 0;
	}
	else if (ty_min > PORTTILESHIGH-1)
	{
		return false;
	}

	ty_max = (py + image.height - 1)/16;	//BUG: shouldn't use sprite height for tiles!
	if (ty_max > PORTTILESHIGH-1)
	{
		ty_max = PORTTILESHIGH-1;
	}
	else if (ty_max < 0)
	{
		return false;
	}

	px += 4;
	py += 32;

	// WARNING: There are no safety measures to prevent the code from adding a
	// new tile entry when the tilearray is already full! This will lead to
	// memory corruption (the data following after spritearray will be
	// overwritten with a new drawtype entry). The same applies to the eraselist
	// array, accessed via eraselistptr here.

	for (ty = ty_min; ty <= ty_max; ty++)
	{
		for (tx = tx_min; tx <= tx_max; tx++)
		{
			*eraselistptr = ty*PORTTILESWIDE + tx;
			eraselistptr++;
		}
	}

	tilefreeptr->x = px;
	tilefreeptr->y = py;
	tilefreeptr->num = tilenum;
	tilecount++;
	tilefreeptr++;

	return true;
}

/*
=============================================================================
*/

/*
=====================
=
= ReadLevel
=
=====================
*/

void ReadLevel(Sint16 levelnum)
{
	void far *buffPtr;
	Sint16 i, handle;
	Sint16 size;
	char numbuf[4];
	char filename[12];

	level = levelnum;
	if (levelnum < 10)
	{
		itoa(levelnum, numbuf, 10);
		strcpy(filename, "LEVEL0");
	}
	else
	{
		itoa(levelnum, numbuf, 10);
		strcpy(filename, "LEVEL");
	}
	strcat(filename, numbuf);
	strcat(filename, ".");
	strcat(filename, _extension);

#if VERSION <= VER_100
	LoadFile(filename, compbuf);
	RLEWExpand(compbuf, (Uint16 far*)bigbuffer);
#else
	handle = open(filename, O_BINARY);
	size = filelength(handle);
	close(handle);

	buffPtr = (char far *)bigbuffer+(0xFFFF-size);
	LoadFile(filename, buffPtr);
	RLEWExpand(buffPtr, (Uint16 far*)bigbuffer);
#endif

	for (i=0; i<((LevelDef far *)bigbuffer)->planes; i++)
	{
		mapplane[i] = (Uint16 far *)(bigbuffer+i*((LevelDef far *)bigbuffer)->planesize+32);
	}
	mapwwide = ((LevelDef far *)bigbuffer)->width;
	mapheight = ((LevelDef far *)bigbuffer)->height;
	mapbwide = mapwwide*2;
	mapbytesextra = mapbwide - 2*PORTTILESWIDE;

	originxmin = 2*TILEGLOBAL;
	originymin = 2*TILEGLOBAL;
	originxmax = TILE_TO_GLOBAL(((LevelDef far *)bigbuffer)->width - PORTTILESWIDE - 1);
	objectxmax = TILE_TO_GLOBAL(((LevelDef far *)bigbuffer)->width - 2);
	objectymax = TILE_TO_GLOBAL(((LevelDef far *)bigbuffer)->height);
	originymax = TILE_TO_GLOBAL(((LevelDef far *)bigbuffer)->height - PORTTILESHIGH - 1) + 8*PIXGLOBAL;
	keenxmax = TILE_TO_GLOBAL(((LevelDef far *)bigbuffer)->width - 3);
	keenymax = TILE_TO_GLOBAL(((LevelDef far *)bigbuffer)->height);
}


/*
=====================
=
= AskQuit
=
=====================
*/

void AskQuit(void)
{
	ClearKeys();
	if (level == 90)
	{
		ExpWin(12, 1);
		Print("Quit (Y/N)?");
		ch = toupper(Get());
		if (ch == 'Y')
		{
			Quit("");
		}
	}
	else
	{
		ExpWin(20, 2);
		Print("Quit to (D)os or\n");
		Print("(T)itle:");
		ch = toupper(Get());
		if (ch == 'D')
		{
			Quit("");
		}
		if (ch == 'T')
		{
			quitToTitle = true;
		}
	}
}


#if VERSION >= VER_100

/*
=====================
=
= JoyButton
=
=====================
*/

Sint16 JoyButton(void)
{
	Uint16 portval;

	portval = inp(0x201);
	if (!(portval & 0x10))
	{
		return 1;
	}
	if (!(portval & 0x20))
	{
		return 2;
	}
	return 0;
}


/*
=====================
=
= WriteHuge	(buggy, never used!)
=
=====================
*/

void WriteHuge(Sint16 handle, void huge *buff, Sint32 size)
{
	Sint16 i, n;
	Uint8 huge *ptr;
	Uint8 tempbuff[16];

	ptr = buff;

	// BUG: this NEVER writes the last 16 bytes! (n should start at 0)
	for (n = 1; size / 16 >= n; n++)
	{
		for (i = 0; i < 16; i++)
		{
			tempbuff[i] = *ptr;
			ptr++;
		}
		if (size / 16 == n)
		{
			write(handle, tempbuff, size % 16);
		}
		else
		{
			write(handle, tempbuff, 16);
		}
	}
}


/*
=====================
=
= DrawPicFile
=
=====================
*/

void DrawPicFile(char *filename)
{
	void far *buffer;
	Sint16 picoff, screenoff;
	Sint16 y;
	Sint16 segBlue, segGreen, segRed, segIntensity;

#if VERSION <= VER_100
	buffer = compbuf;
	LoadFile(filename, compbuf);
	buffer = paralloc(0x8000);
	RLEExpand(compbuf, buffer);
#else
	buffer = bigbuffer + 0x8000;
	LoadFile(filename, buffer);
	RLEExpand(buffer, bigbuffer);
#endif

	segBlue = FP_SEG(buffer);
	segGreen = segBlue + 0x200;
	segRed = segGreen + 0x200;
	segIntensity = segRed + 0x200;

	picoff = 0;
	screenoff = 4;
	originxglobal = originyglobal = 0;
	RF_Clear();
	RF_Refresh();

	outport(GC_INDEX, GC_MODE);	// read mode 0
	for (y=0; y<200; y++)
	{
		outportb(SC_INDEX, SC_MAPMASK);
		outportb(SC_INDEX+1, 1);
		movedata(segBlue, picoff, screenseg, screenoff, 40);
		outportb(SC_INDEX, SC_MAPMASK);
		outportb(SC_INDEX+1, 2);
		movedata(segGreen, picoff, screenseg, screenoff, 40);
		outportb(SC_INDEX, SC_MAPMASK);
		outportb(SC_INDEX+1, 4);
		movedata(segRed, picoff, screenseg, screenoff, 40);
		outportb(SC_INDEX, SC_MAPMASK);
		outportb(SC_INDEX+1, 8);
		movedata(segIntensity, picoff, screenseg, screenoff, 40);
		picoff += 40;
		screenoff += SCREENWIDTH;
	}
	outportb(SC_INDEX, SC_MAPMASK);
	outportb(SC_INDEX+1, 0xF);
	RF_ForceRefresh();
	
#if VERSION <= VER_100
	farfree(lastparalloc);
#endif
}


/*
=====================
=
= SaveScreenshot
=
=====================
*/

void SaveScreenshot(void)
{
	Sint16 y;

#if VERSION <= VER_100
#define BUFFER compbuf
#else
#define BUFFER bigbuffer
#endif

	outport(GC_INDEX, GC_MODE);	// read mode 0
	outportb(GC_INDEX, GC_READMAP);
	outportb(GC_INDEX+1, 0);
	for (y=0; y<200; y++)
	{
		movedata(screenseg, y*48+4, FP_SEG(BUFFER), y*40, 40);
	}
	outportb(GC_INDEX, GC_READMAP);
	outportb(GC_INDEX+1, 1);
	for (y=0; y<200; y++)
	{
		movedata(screenseg, y*48+4, FP_SEG(BUFFER), y*40 + 0x2000, 40);
	}
	outportb(GC_INDEX, GC_READMAP);
	outportb(GC_INDEX+1, 2);
	for (y=0; y<200; y++)
	{
		movedata(screenseg, y*48+4, FP_SEG(BUFFER), y*40 + 0x4000, 40);
	}
	outportb(GC_INDEX, GC_READMAP);
	outportb(GC_INDEX+1, 3);
	for (y=0; y<200; y++)
	{
		movedata(screenseg, y*48+4, FP_SEG(BUFFER), y*40 + 0x6000, 40);
	}
	SaveFile("KEENSCRN.PIC", BUFFER, 0x8000);
#undef BUFFER
}

#endif	// if VERSION >= VER_100


/*
=====================
=
= HandleHotkeys
=
=====================
*/

boolean HandleHotkeys(void)
{
	Sint32 oldtime;
#if VERSION <= VER_120
	Sint16 key = bioskey(1) / 0x100;
#endif
	Sint16 i = 0;

#if (VERSION >= VER_100) && (VERSION <= VER_120)
	if (joyDetected && playermode[1] != joystick1 && JoyButton())
	{
		while (JoyButton());
		key = KEY_F4;
	}
#elif VERSION > VER_120
	NoBiosKey(1);
#endif

	if (key == 0)	//useless in v1.31 (key is an array, this checks if the address of the array is 0)
	{
		return false;
	}

	oldtime = timecount;
#if VERSION <= VER_120
	switch (key)
#else
	switch (NBKscan & 0x7F)
#endif
	{
	case KEY_F1:
#if VERSION >= VER_100
		PauseSound();
#endif
		ClearKeys();
		ShowHelpText();
		i++;
		break;

	case KEY_F2:
#if VERSION >= VER_100
		PauseSound();
#endif
		ClearKeys();
		ExpWin(13, 1);
		Print("Sound (Y/N)?");
		ch = toupper(Get());
		if (ch == 'N')
		{
			soundmode = 0;
		}
		else if (ch == 'Y')
		{
			soundmode = 1;
		}
		i++;
		break;

	case KEY_F3:
#if VERSION >= VER_100
		PauseSound();
#endif
		ClearKeys();
		CalibrateKeys();
		i++;
		break;

	case KEY_F4:
#if VERSION >= VER_100
		PauseSound();
#endif
		ClearKeys();
		CalibrateJoy(1);
		i++;
		break;

	case KEY_F5:
#if VERSION >= VER_100
		PauseSound();
#endif
		SaveMenu();
		i++;
		break;

#if (VERSION >= VER_100) && (VERSION <= VER_120)
	case KEY_F8:
		SaveScreenshot();
		PlaySound(SND_GOTBONUS);
		WaitEndSound();
		ClearKeys();
		break;
#endif

	case KEY_ESC:
#if VERSION >= VER_100
		PauseSound();
#endif
		AskQuit();
		i++;
		break;

	default:
		return false;
	}
#if VERSION < VER_100
	RF_ForceRefresh();
#endif
	timecount = oldtime;

	if (i)
	{
		ClearKeys();
#if VERSION >= VER_100
		ContinueSound();
		RF_ForceRefresh();
#endif
		return true;
	}
	else
	{
		return false;
	}
}


/*
=====================
=
= AddScore
=
=====================
*/

void AddScore(Sint16 toadd)
{
	gamestate.score += toadd;
#if VERSION < VER_100
	if (gamestate.score - lastExtraScore > EXTRASCORE)
#else
	if (gamestate.score - lastExtraScore >= EXTRASCORE)
#endif
	{
		PlaySound(SND_EXTRAMAN);
		lastExtraScore = (gamestate.score / EXTRASCORE) * EXTRASCORE;
		gamestate.lives++;
	}
}


/*
=====================
=
= DoCheat
=
=====================
*/

void DoCheat(void)
{
	Sint32 oldtime;
	Sint16 i;

	oldtime = timecount;
	ClearKeys();

	ExpWin(26, 4);
#if (EPISODE == 1)
	Print("You are now cheating!\n");
	Print("You just got a pogo stick,\n");
	Print("all the key cards, and\n");
	Print("lots of ray gun charges.");
#else
	Print("You are now cheating!\n");
	Print("You just got all the\n");
	Print("key cards, and lots of\n");
	Print("ray gun charges.");
#endif

	gamestate.gotPogo = true;
	gamestate.ammo = 100;
	for (i=0; i<NUMKEYS; i++)
	{
		gamestate.keys[i] = true;
	}
#if VERSION < VER_100
	infoBlockMask = 0;
#endif

	Get();	// wait for a keypress (with animated cursor)

	RF_ForceRefresh();
	RF_Refresh();
	RF_Refresh();

	timecount = oldtime;
	ClearKeys();
}


/*
=====================
=
= ShowStatusScreen
=
=====================
*/

void ShowStatusScreen(void)
{
	Sint16 i, y;
	Sint16 x;
	Sint32 oldtime;

	oldtime = timecount;
	ClearKeys();

	// Note: The window background is white, but the text is drawn
	// using the second part of the font (red text on grey background).
	// The blank spaces are drawn as grey blocks in the white window.

#if (EPISODE == 1)

	ExpWin(28, 13);
	x = sx;
	y = sy;
	DrawText("    SCORE     EXTRA KEEN AT \n");
	sx = x+12;
	DrawText(" \n");
	DrawText("    KEENS       SHIP PARTS  \n");
	sx = x+14;
	DrawText(" \n");
	sx = x+14;
	DrawText(" \n");
	sx = x+14;
	DrawText(" \n");
	DrawText(" RAYGUN   POGO    KEYCARDS  \n");
	sx = x+8;
	DrawText(" ");
	sx += 6;
	DrawText(" \n");
	sx = x+8;
	DrawText(" ");
	sx += 6;
	DrawText(" \n");
	sx = x+8;
	DrawText(" ");
	sx += 6;
	DrawText(" \n");
	DrawText(" CHARGE  ");
	sx += 6;
	DrawText(" \n");
	sx = x+8;
	DrawText(" ");
	sx += 6;
	DrawText(" \n");
	DrawText("     PLEASE PRESS A KEY     ");

	ltoa(gamestate.score, str, 10);
	sx = x+10 - strlen(str);
	sy = y+1;
	Print(str);

	ltoa(lastExtraScore+EXTRASCORE, str, 10);
	sx = x+26 - strlen(str);
	Print(str);

	for (i=0; i<gamestate.lives && i<6; i++)
	{
		DrawSprite(x+i*2 + 1, (y + 3)*8, SPR_KEENWALKR1*4);	// *4 because each sprite has 4 shifts!
	}

	sx = x+16;
	sy = y+3;
	DrawTile(sx, sy*8 + 4, gamestate.gotJoystick? 448 : 321);
	sx += 3;
	DrawTile(sx, sy*8 + 4, gamestate.gotBattery? 449 : 322);
	sx += 3;
	DrawTile(sx, sy*8 + 4, gamestate.gotVacuum? 450 : 323);
	sx += 3;
	DrawTile(sx, sy*8 + 4, gamestate.gotWhiskey? 451 : 324);

	sx = x+19;
	sy = y+7;
	if (gamestate.keys[0])
	{
		DrawTile(sx, sy*8 + 3, 424);
	}
	if (gamestate.keys[1])
	{
		DrawTile(sx + 4, sy*8 + 3, 425);
	}
	if (gamestate.keys[2])
	{
		DrawTile(sx, sy*8 + 21, 426);
	}
	if (gamestate.keys[3])
	{
		DrawTile(sx + 4, sy*8 + 21, 427);
	}

	DrawTile(x + 3, (y+7)*8 + 4, 414);	// raygun icon
	sx = x+3;
	sy = y+11;
	PrintInt(gamestate.ammo);

	if (gamestate.gotPogo)
	{
		DrawTile(x+11, (y+8)*8 + 4, 415);
	}

#elif (EPISODE == 2)

	ExpWin(28, 12);
	x = sx;
	y = sy;
	DrawText("    SCORE     EXTRA KEEN AT \n");
	sx = x+12;
	DrawText(" \n");
	DrawText("    KEENS            PISTOL \n");
	sx = x+19;
	DrawText(" \n");
	sx = x+19;
	DrawText(" \n");
	sx = x+19;
	DrawText(" \n");
	DrawText("   TARGETS SAVED      KEYS  \n");
	sx = x+19;
	DrawText(" \n");
	sx = x+19;
	DrawText(" \n");
	sx = x+19;
	DrawText(" \n");
	sx = x+19;
	DrawText(" \n");
	DrawText("     PLEASE PRESS A KEY     ");

	ltoa(gamestate.score, str, 10);
	sx = x+10 - strlen(str);
	sy = y+1;
	Print(str);

	ltoa(lastExtraScore+EXTRASCORE, str, 10);
	sx = x+26 - strlen(str);
	Print(str);

	for (i=0; i<gamestate.lives && i<9; i++)
	{
		DrawSprite(x+i*2 + 1, (y + 3)*8, SPR_KEENWALKR1*4);	// *4 because each sprite has 4 shifts!
	}

	DrawTile(x+21, (y+3)*8 + 4, 414);	// raygun icon
	sx = x+24;
	sy = y+4;
	PrintInt(gamestate.ammo);

	sx = x+21;
	sy = y+7;
	if (gamestate.keys[0])
	{
		DrawTile(sx, sy*8, 424);
	}
	if (gamestate.keys[1])
	{
		DrawTile(sx + 4, sy*8, 425);
	}
	if (gamestate.keys[2])
	{
		DrawTile(sx, sy*8 + 16, 426);
	}
	if (gamestate.keys[3])
	{
		DrawTile(sx + 4, sy*8 + 16, 427);
	}

	if (gamestate.citySaved[CITY_LONDON])
	{
		sx = x;
		sy = y+7;
		Print("London");
	}
	if (gamestate.citySaved[CITY_CAIRO])
	{
		sx = x;
		sy = y+8;
		Print("Cairo");
	}
	if (gamestate.citySaved[CITY_SYDNEY])
	{
		sx = x;
		sy = y+9;
		Print("Sydney");
	}
	if (gamestate.citySaved[CITY_NEWYORK])
	{
		sx = x;
		sy = y+10;
		Print("New York");
	}
	if (gamestate.citySaved[CITY_PARIS])
	{
		sx = x+10;
		sy = y+7;
		Print("Paris");
	}
	if (gamestate.citySaved[CITY_ROME])
	{
		sx = x+10;
		sy = y+8;
		Print("Rome");
	}
	if (gamestate.citySaved[CITY_MOSCOW])
	{
		sx = x+10;
		sy = y+9;
		Print("Moscow");
	}
	if (gamestate.citySaved[CITY_WASHINGTONDC])
	{
		sx = x+10;
		sy = y+10;
		Print("Wash D.C.");
	}

#elif (EPISODE == 3)

	ExpWin(28, 11);
	x = sx;
	y = sy;
	DrawText("    SCORE     EXTRA KEEN AT \n");
	sx = x+12;
	DrawText(" \n");
	DrawText("    KEENS            PISTOL \n");
	sx = x+19;
	DrawText(" \n");
	sx = x+19;
	DrawText(" \n");
	sx = x+19;
	DrawText(" \n");
	DrawText(" ANKH TIME      KEY CARDS   \n");
	sx = x+11;
	DrawText(" \n");
	sx = x+11;
	DrawText(" \n");
	sx = x+11;
	DrawText(" \n");
	DrawText("     PLEASE PRESS A KEY     ");

	ltoa(gamestate.score, str, 10);
	sx = x+10 - strlen(str);
	sy = y+1;
	Print(str);

	ltoa(lastExtraScore+EXTRASCORE, str, 10);
	sx = x+26 - strlen(str);
	Print(str);

	for (i=0; i<gamestate.lives && i<9; i++)
	{
		DrawSprite(x+i*2 + 1, (y + 3)*8, SPR_KEENWALKR1*4);	// *4 because each sprite has 4 shifts!
	}

	DrawTile(x+21, (y+3)*8 + 4, 216);	// raygun icon
	sx = x+24;
	sy = y+4;
	PrintInt(gamestate.ammo);

	DrawTile(x+3, (y+7)*8 + 4, 214);	// ankh icon
	sx = x+7;
	sy = y+8;
	PrintInt(invincible/144);	// this many seconds left

	sx = x+13;
	sy = y+8;
	if (gamestate.keys[0])
	{
		DrawTile(sx, sy*8 - 4, 217);
	}
	if (gamestate.keys[1])
	{
		DrawTile(sx + 4, sy*8 - 4, 218);
	}
	if (gamestate.keys[2])
	{
		DrawTile(sx + 8, sy*8 - 4, 219);
	}
	if (gamestate.keys[3])
	{
		DrawTile(sx + 12, sy*8 - 4, 220);
	}

#endif

	ClearKeys();
	NoBiosKey(0);	// wait for a keypress (no animation)

	RF_ForceRefresh();
	RF_Refresh();
	RF_Refresh();
	ClearKeys();
	timecount = oldtime;
}


/*
=====================
=
= HandleUserKeys
=
=====================
*/

void HandleUserKeys(void)
{
	if (keydown[KEY_C] && keydown[KEY_T] && keydown[KEY_SPACE])
	{
		DoCheat();
	}
#if VERSION >= VER_100
	if (keydown[KEY_G] && keydown[KEY_O] && keydown[KEY_D])
	{
		ClearKeys();
		ExpWin(20, 1);
		if (godmode ^= true)
		{
			Print("God mode enabled");
		}
		else
		{
			Print("God mode disabled");
		}
		Get();	// wait for a keypress (with animated cursor)
		RF_ForceRefresh();
		// BUG: timing gets messed up here!
	}
	else if (keydown[KEY_SPACE])
	{
		PauseSound();
		ShowStatusScreen();
		ContinueSound();
	}
#else
	else if (keydown[KEY_SPACE])
	{
		ShowStatusScreen();
	}
#endif
}


/*
=====================
=
= Quit
=
=====================
*/

void Quit(char *error)
{
	// change to text mode (and clear the screen):
	_AX = 3;
	geninterrupt(0x10);

	if (!*error)
	{
		SaveCtrls();
	}
	else
	{
		puts(error);
	}

	if (KBDstarted)
	{
		ShutdownKbd();
	}
	if (SNDstarted)
	{
		ShutdownSound();
	}

#if VERSION >= VER_134
	if (!*error)
	{
		clrscr();
		movedata(FP_SEG(endscreen), FP_OFF(endscreen)+7, 0xB800, 0, 4000);
		gotoxy(1, 20);
		exit(0);
	}
	// BUG: version 1.34 doesn't actually exit to DOS here when an error message
	// was passed to the Quit function. That's NOT how this was supposed to work.
#else
#if VERSION < VER_100
	if (!tedlevelnum)
#elif VERSION <= VER_120
	if (!*error && !tedlevelnum)
#else
	if (!*error)
#endif
	{
		movedata(FP_SEG(endscreen), FP_OFF(endscreen)+7, 0xB800, 0, 4000);
	}
	gotoxy(1, 23);
	exit(0);
#endif
}


/*
=====================
=
= main
=
=====================
*/

void main(Sint16 argc, char **argv)
{
	Sint16 i;
	Sint16 joyX, joyY;
	
#if VERSION == VER_132
	{
		extern char far introscn[];
		
		movedata(FP_SEG(introscn), FP_OFF(introscn)+7, 0xB800, 0, 4000);
		gotoxy(1, 21);
		puts("Press a key:");
		if (bioskey(1))	// if a key was pressed
		{
			bioskey(0);	// remove key from input buffer
		}
		bioskey(0);	// wait for next keypress
		gotoxy(1, 21);
	}
#endif

#if VERSION < VER_134
	strcpy(_extension, EXTENSION);
	puts(LOADMSG);
#else
	clrscr();
	textbackground(CYAN);
	textcolor(BLACK);
	strcpy(_extension, EXTENSION);
	cprintf(LOADMSG"\r\n\n");
	textbackground(BLACK);
	// Note: This code has now set both the text color and the background color
	// to black, which would make the text invisible on the screen. But these
	// colors aren't used by puts, which means the text messages following below 
	// will still be visible at startup.
#endif

#if VERSION >= VER_100
	ReadJoystick(1, &joyX, &joyY);
	if (joyX < 500)
	{
		puts("Joystick detected");
		joyDetected = true;
	}
	else
	{
		puts("Joystick not detected");
		joyDetected = false;
	}
#endif

#if VERSION <= VER_120
	if (argc > 1 && !strcmp(strupr(argv[1]), "/LEVEL"))
	{
		char filename[20] = "";
		
		strcpy(filename, "TEDLEVEL.");
		strcat(filename, _extension);
		LoadFile(filename, &tedlevelnum);
	}
	else
	{
		tedlevelnum = 0;
	}
#endif

#ifndef OLDKEYBOARD
	stillCallOldInt9 = true;
	if (argc > 1 && (argv[1][1] == 'K' || argv[1][1] == 'k'))
	{
		stillCallOldInt9 = false;
		puts("Keystrokes will not be passed to bios");
	}
#endif

	videocard = VideoID();
#if VERSION < VER_100
	if (videocard != EGAcard && videocard != VGAcard)
	{
		puts("Sorry, you need an EGA or VGA graphic card to play Commander Keen.");
		puts("Buy one!");
		exit(1);
	}
#else
	if (videocard == EGAcard)
	{
		puts("EGA card detected");
	}
	else if (videocard == VGAcard)
	{
		puts("VGA card detected");
	}
	else
	{
		puts("Hey, I don't see an EGA or VGA card here!  Do you want to run the program ");
		puts("anyway (Y = go ahead, N = quit to dos) ?");
		ClearKeys();
		i = toupper(NoBiosKey(0) & 0xFF);	//BUG: keyboard services haven't been started yet! (must use bioskey instead of NoBiosKey)
		if (i != 'Y')
		{
			exit(1);	
		}
	}
#endif

#if (VERSION > VER_110) && (defined USE_LZW)
	puts("Decompressing graphics, this may take some time...");
#endif
	LoadGraphics();

	for (i=0; i<numtiles; i++)
	{
		switch (tile_numframes[i])
		{
		case 1:
			tile_anim0[i] = tile_anim1[i] = tile_anim2[i] = tile_anim3[i] = (i << 5);
			break;

		case 2:
			tile_anim0[i] = tile_anim2[i] = (i << 5);
			tile_anim1[i] = tile_anim3[i] = (i << 5) + 0x20;
			i++;
			tile_anim0[i] = tile_anim2[i] = (i << 5);
			tile_anim1[i] = tile_anim3[i] = (i << 5) - 0x20;
			break;

		case 4:
			tile_anim0[i] = (i << 5);
			tile_anim1[i] = (i << 5) + 0x20;
			tile_anim2[i] = (i << 5) + 0x40;
			tile_anim3[i] = (i << 5) + 0x60;
			i++;
			tile_anim0[i] = (i << 5);
			tile_anim1[i] = (i << 5) + 0x20;
			tile_anim2[i] = (i << 5) + 0x40;
			tile_anim3[i] = (i << 5) - 0x20;
			i++;
			tile_anim0[i] = (i << 5);
			tile_anim1[i] = (i << 5) + 0x20;
			tile_anim2[i] = (i << 5) - 0x40;
			tile_anim3[i] = (i << 5) - 0x20;
			i++;
			tile_anim0[i] = (i << 5);
			tile_anim1[i] = (i << 5) - 0x60;
			tile_anim2[i] = (i << 5) - 0x40;
			tile_anim3[i] = (i << 5) - 0x20;
			break;
		}
	}

#ifdef SOUNDSLINKED
	{
		extern char far _sounds[];
		SoundData = _sounds;
	}
#else
	strcpy(str, "SOUNDS.");
	strcat(str, _extension);
	SoundData = bloadin(str);
#endif

	InitRndT(true);
	InitRnd(true);

	StartupSound();
	SNDstarted = true;

#ifdef OLDKEYBOARD
	SetupKBD();
#else
	StartupKbd();
#endif
	KBDstarted = true;

	LoadCtrls();
	playermode[1] = keyboard;	// always start in keyboard mode (in case joystick is no longer present, I guess)

	bigbuffer = (Uint8 far *)paralloc(0x10000);
#if VERSION <= VER_100
	compbuf = (Uint8 far *)paralloc(0x8000);
#endif
	screencenterx = SCREENWIDTH/2-1;
	tileAnimDelay = 7;	// this value is never actually used (see MenuLoop and PlayLoop)
	timecount = lasttimecount = 0;

	DemoLoop();
}